# -*- python -*-
# This file is a modified version of pybformat from pybliographer, that
# can be used in connection with pyblink.
#
# 
# Copyright (C) 1998-2004 Frederic GOBRY
# Email : gobry@pybliographer.org
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
#

import string, sys, os, getopt

from Pyblio.Output import latexutils

from Pyblio import Base, Autoload
from Pyblio.Style import Utils

import locale
charset = locale.getlocale () [1] or 'ascii'

def usage ():
    sys.stderr.write (_("usage: pyblinkformat [options] <database...>\n").encode (charset))
    return

def error (text, exit = 1):
    sys.stderr.write ((_("pyblinkformat: error: %s\n") % text).encode (charset))
    if exit:
        sys.exit (1)
    return

def warning (text, exit = 0):
    sys.stderr.write ((_("pyblinkformat: warning: %s\n") % text).encode (charset))
    if exit:
        sys.exit (1)
    return

optlist, args = getopt.getopt (sys.argv [2:],
			       'H:F:o:l:vhs:f:i:',
			       ['header=',
				'footer=',
                                'output=',
                                'list=',
                                'style=',
                                'format=',
                                'idfile=',
				'version',
				'help'])

header  = None
footer  = None
outfile = sys.stdout
format  = 'text'
style   = 'Alpha'
idfile  = None

for opt, value in optlist:
    if opt == '-H' or opt == '--header':
        header = value
        continue
    
    if opt == '-F' or opt == '--footer':
        footer = value
        continue

    if opt == '-o' or opt == '--output':
        try:
            outfile = open (value, 'w')
        except IOError, err:
            error (_("can't open `%s': %s") % (value, str (err).decode (charset)))
        continue

    if opt == '-i' or opt == '--idfile':
        try:
            idfile = open (value, 'r')
        except IOError, err:
            error (_("can't open `%s': %s") % (value, str (err).decode (charset)))
        continue

    if opt == '-l' or opt == '--list':
        try:
            list = Autoload.available (value)
        except KeyError:
            error (_("unknown list `%s'") % value)
            
        if list:
            print (_("pyblinkformat: available values for `%s':") % value).encode (charset)
            print "  " + string.join (list, ", ")
            sys.exit (0)
        else:
            warning (_("empty value list `%s'") % value)
            sys.exit (0)
            
    if opt == '-h' or opt == '--help':
        usage ()
        sys.exit (0)
        continue

    if opt == '-s' or opt == '--style':
        style = value
        continue

    
    if opt == '-f' or opt == '--format':
        format = value
        continue
    

    if opt == '-v' or opt == '--version':
        usage ()
        sys.exit (0)
        continue


# test input arguments
if len (args) < 1:
    # user gave wrong arguments...
    usage ()
    error (_("too few arguments"))

files  = args

# get the specified style and the output
output = Autoload.get_by_name ('output', format)
if output is None:
    error (_("unknown output format `%s'") % format)

url = None
style = os.path.splitext (style) [0]
if os.path.exists (style + '.xml'):
    url = Fields.URL (style + '.xml')
else:
    from Pyblio import version
    full = os.path.join (version.pybdir, 'Styles', style)
    full = full + '.xml'
    if os.path.exists (full): url = Fields.URL (full)

if not url:
    error (_("can't find style `%s'") % style)

# Fetch id-list from idfile
idlist=[]
if idfile:
    line = '\n'
    while line:
	line = string.rstrip(idfile.readline())
	if line:
   	    idlist.append(line)
    idfile.close ()

sys.stderr.write ((_("pyblinkformat: using style `%s', format `%s'\n") % (style, output.name)).encode (charset))

formatter = output.data

# first, write the header
if header:
    try:
        h = open (header, 'r')
        line = '\n'
        while line:
            line = h.readline ()
            if line:
                outfile.write (line)
        h.close ()
    except IOError, err:
        error (_("can't open header `%s': %s") % (header, str (err).decode (charset)))

# write the data
for file in files:

    try:
        db = bibopen (file)
    except IOError, err:
        error (_("can't open database: %s") % file)

    if len(idlist) == 0:
	idlist = db.keys()
    else:
	keylist = db.keys()
	idlist2 = []
        for l in idlist:
	    for k in keylist:
		if l == k.__str__()[:len(l)]:
	            idlist2.append(k)

	idlist = idlist2

    Utils.generate (url, formatter, db, idlist, outfile)
    
# last, write the footer
if footer:
    try:
        h = open (footer, 'r')
        line = '\n'
        while line:
            line = h.readline ()
            if line:
                outfile.write (line)
        h.close ()
    except IOError, err:
        error (_("can't open footer `%s': %s") % (footer, str (err).decode (charset)))

        
outfile.close ()
